/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.texture;

import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class Fill {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int[][] rot;
    private final int u;
    private final int v;

    Fill(int x, int y, int width, int height, int[][] rot, int u, int v) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rot = rot;
        this.u = u;
        this.v = v;
    }

    void fill(NativeImage image, TextureAtlasSprite sprite, int resolution, int outResolution) {
        int r = outResolution / resolution;
        int x1 = (this.x + this.width) * resolution;
        int y1 = (this.y + this.height) * resolution;
        int u0 = this.u * resolution;
        int v0 = this.v * resolution;
        for (int y = this.y * resolution; y < y1; ++y) {
            for (int dy = 0; dy < r; ++dy) {
                for (int x = this.x * resolution; x < x1; ++x) {
                    for (int dx = 0; dx < r; ++dx) {
                        int u1 = x * this.rot[0][0] + y * this.rot[0][1] + Math.min(this.rot[0][0], this.rot[0][1]) + u0;
                        int v1 = x * this.rot[1][0] + y * this.rot[1][1] + Math.min(this.rot[1][0], this.rot[1][1]) + v0;
                        int rgba = sprite.getPixelRGBA(0, Math.floorMod(u1, sprite.func_94211_a()), Math.floorMod(v1, sprite.func_94216_b()));
                        image.func_195700_a(r * x + dx, r * y + dy, rgba);
                    }
                }
            }
        }
    }
}

